/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.feathers;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.extern.feathers.FeathersStamina;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;

public class FeathersManager {
    private static boolean feathersInstalled = false;

    public static boolean isFeathersInstalled() {
        return feathersInstalled;
    }

    public static void init() {
        IModFileInfo mod = ModList.get().getModFileById("feathers");
        feathersInstalled = mod != null;
    }

    @Nullable
    public static IStamina newFeathersStaminaFor(Player player) {
        if (!feathersInstalled) {
            return null;
        }
        return new FeathersStamina(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isUsingFeathers() {
        return feathersInstalled && (Boolean)ParCoolConfig.CONFIG_CLIENT.useFeathers.get() != false;
    }
}

